function [vip, viptot]=myvip2(T,W,R,Q,B)
    nx   = size(R,1);
    ny   = size(Q,1);
    vip=zeros(size(B));
       
    TT = sum(T.^2,1);
    
    if ~isempty(W)
        W_norm = (W*diag(1./sqrt(sum(W.^2,1))));  % normalized weights
    else
        W_norm = (R*diag(1./sqrt(sum(R.^2,1))));  % normalized weights
    end
    SSfY=0;
    
    for i = 1:ny
        % calculate regression in terms of scores (T*b = y_hat)
        b  = R\B(:,i);
        
        % calculate weighted T^2
        SS = b.^2.*TT';
        
        SSfY=SSfY+SS;
        
        % VIP scores for this y
        vip(:,i) = sqrt(nx*W_norm.^2*SS./sum(SS));
    end
    
    % TOTAL VIP
    sstot=sum(SSfY);
    viptot = sqrt(nx*W_norm.^2*SSfY./sstot);
end